// Credit: Arshad Muhammad - https://code-projects.org/2d-traffic-racer-game-in-jquery-with-source-code/
$(function() {
    var anim_id;
    var container = $('#container');
    var spaceship = $('#spaceship');
    var laser = $('#laser');
    var alienship = $('#alienship')
    var explode = $('#explode')
    var alien = $('#alien');
    var flame = $('#flame');
    var asteroid_1 = $('#asteroid_1');
    var asteroid_2 = $('#asteroid_2');
    var asteroid_3 = $('#asteroid_3');
    var restart_div = $('#restart_div');
    var restart_btn = $('#restart');
    var score = $('#score');
      
    var container_left = parseInt(container.css('left'));
    var container_right = parseInt(container.css('right'));
    var container_width = parseInt(container.width());
    var container_height = parseInt(container.height());
    var spaceship_width = parseInt(spaceship.width());
    var spaceship_height = parseInt(spaceship.height());
    var alien_width = parseInt(alien.width());
    var alien_height = parseInt(alien.height());

    var game_over = false;
    var score_counter = 1;
    var speed = 3;

    var move_right = false;
    var move_left = false;
    var move_up = false;
    var move_down = false;
    var fire_laser = false;



// Creating the controls
$(document).on('keydown', function(e) {
    if (game_over === false) {
    var key = e.keyCode;
        if (key === 37 && move_left === false) {
            move_left = requestAnimationFrame(left);
        } else if (key === 39 && move_right === false) {
            move_right = requestAnimationFrame(right);
        } else if (key === 38 && move_up === false) {
            move_up = requestAnimationFrame(up);
            flame.css('display', 'block');
        } else if (key === 40 && move_down === false) {
            move_down = requestAnimationFrame(down);  
        } else if (key === 32 && fire_laser === false) {
            laser.css('left', parseInt(spaceship.css('left')) + 20);
            laser.css('top', parseInt(spaceship.css('top')) - 10);
            laser.css('visibility', 'visible');
            fire_laser = requestAnimationFrame(shoot);
        }       
    }
});

$(document).on('keyup', function(e) {
    if (game_over === false) {
    var key = e.keyCode;
        if (key === 37) {
            cancelAnimationFrame(move_left);
            move_left = false;
        } else if (key === 39) {
            cancelAnimationFrame(move_right);
            move_right = false;
        } else if (key === 38) {
            cancelAnimationFrame(move_up);
            move_up = false;
            flame.css('display', 'none');
        } else if (key === 40) {
            cancelAnimationFrame(move_down);
            move_down = false;
        }}
    });


function shoot() {
    if (game_over === false && parseInt(laser.css('top')) > 0) {
        laser.css('top', parseInt(laser.css('top')) - 10);
    if (parseInt(laser.css('top')) <= 0) {
        fire_laser = false; 
        laser.css('visibility', 'hidden');
        cancelAnimationFrame(shoot);
            }
    else {
        fire_laser = requestAnimationFrame(shoot);
        var sound = document.getElementById("sound");
            sound.play(playAudio);
        }
    }
}

function playAudio() { 
  sound.play();      
    }


function left() {
    if (game_over === false && parseInt(spaceship.css('left')) > 0) {
        spaceship.css('left', parseInt(spaceship.css('left')) - 5);
        move_left = requestAnimationFrame(left);
    }
}

function right() {
    if (game_over === false && parseInt(spaceship.css('left')) < container_width - spaceship_width) {
        spaceship.css('left', parseInt(spaceship.css('left')) + 5);
        move_right = requestAnimationFrame(right);
        }
    }

function up() {
    if (game_over === false && parseInt(spaceship.css('top')) > 0) {
        spaceship.css('top', parseInt(spaceship.css('top')) - 3);
        move_up = requestAnimationFrame(up);
        }
    }

function down() {
    if (game_over === false && parseInt(spaceship.css('top')) < container_height - spaceship_height) {
        spaceship.css('top', parseInt(spaceship.css('top')) + 3);
        move_down = requestAnimationFrame(down);
        }
    }

anim_id = requestAnimationFrame(repeat);
// Game over if spaceship crashes into asteroids

function repeat() {
    if (collision(spaceship, asteroid_1) || collision(spaceship, asteroid_2) || collision(spaceship, asteroid_3) || collision(spaceship, alienship)) {
        stop_the_game();
        var crashsound = document.getElementById("crashsound");
            crashsound.play(playAudio);
                return;
        }

//ensuring that the laser will destroy the alien spaceship
if (iscollidingwithlaser(laser, alienship)) {
    requestAnimationFrame(alien_down);
    var explosionsound = document.getElementById("explosionsound");
        explosionsound.play(playAudio);
        alienship.css('display', 'none');
        explode.css('display', 'block');
//the score should go up by 5 points when the alien is killed
    
        score.text(parseInt(score.text()) + 5);
         }

      score_counter++;

        if (score_counter % 20 == 0) {
            score.text(parseInt(score.text()) + 1);
        }
        if (score_counter % 500 == 0) {
            speed++;
           
        }
          
// This will make the asteroids and alien ship move (credit to Arshad Muhammed, cited above)
        
    spaceship_down(alien);
    spaceship_down(asteroid_1);
    spaceship_down(asteroid_2);
    spaceship_down(asteroid_3);
    alien_down(alienship);
    alien_down(explode);
    anim_id = requestAnimationFrame(repeat);
    }

function spaceship_down(spaceship) {
    var spaceship_current_top = parseInt(spaceship.css('top'));
    if (spaceship_current_top > container_height) {
        spaceship_current_top = -200;
    var spaceship_left = parseInt(Math.random() * (container_width - spaceship_width));
        spaceship.css('left', spaceship_left); 
        }
        // the speed at which the asteroids fall increases everytime they reach the bottom of the screen
        spaceship.css('top', spaceship_current_top + speed);    
        }
    
        restart_btn.click(function() {
        location.reload();
        });


function alien_down() {
     var alien_current_top = parseInt(alien.css('top'));
     if (alien_current_top > container_height) {
            alien_current_top = -200;  
    var alien_left = parseInt(Math.random() * (container_width - alien_width));
        alien.css('left', alien_left); 
        alienship.css('display', 'block');
        explode.css('display', 'none');
        }
        alien.css('top', alien_current_top);
        }

function stop_the_game() {
    game_over = true;
        cancelAnimationFrame(anim_id);
        cancelAnimationFrame(move_right);
        cancelAnimationFrame(move_left);
        cancelAnimationFrame(move_up);
        cancelAnimationFrame(move_down);
    restart_div.slideDown();
    restart_btn.focus();
    }

// Collision detection where div1 = player's spaceship and div2 = asteroids/alienspaceship
function collision($div1, $div2) {
    var x1 = $div1.offset().left;
    var y1 = $div1.offset().top;
    var h1 = $div1.outerHeight(true);
    var w1 = $div1.outerWidth(true);
    var b1 = y1 + h1;
    var r1 = x1 + w1;
    var x2 = $div2.offset().left;
    var y2 = $div2.offset().top;
    var h2 = $div2.outerHeight(true);
    var w2 = $div2.outerWidth(true);
    var b2 = y2 + h2;
    var r2 = x2 + w2;

    if (b1 < y2 || y1 > b2 || r1 < x2 || x1 > r2) return false;
    return true;
    }

//collision detection where div1 = laser and div2 = alien spaceship
function iscollidingwithlaser($div1, $div2) {

    var x1 = $div1.offset().left;
    var y1 = $div1.offset().top;
    var h1 = $div1.outerHeight(true);
    var w1 = $div1.outerWidth(true);
    var b1 = y1 + h1;
    var r1 = x1 + w1;
    var x2 = $div2.offset().left;
    var y2 = $div2.offset().top;
    var h2 = $div2.outerHeight(true);
    var w2 = $div2.outerWidth(true);
    var b2 = y2 + h2;
    var r2 = x2 + w2;
    var visibility = $div1.css('visibility');

    if (b1 < y2 || y1 > b2 || r1 < x2 || x1 > r2 || visibility == 'hidden') return false;
    return true;
    }
    });
